package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.FlowName
import scala.jdk.CollectionConverters.*
final case class StartFlowRequest(flowName: FlowName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.StartFlowRequest = {
    import StartFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.StartFlowRequest
      .builder()
      .flowName(FlowName.unwrap(flowName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.StartFlowRequest.ReadOnly =
    zio.aws.appflow.model.StartFlowRequest.wrap(buildAwsValue())
}
object StartFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.StartFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.StartFlowRequest =
      zio.aws.appflow.model.StartFlowRequest(flowName)
    def flowName: FlowName
    def getFlowName: ZIO[Any, Nothing, FlowName] = ZIO.succeed(flowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.StartFlowRequest
  ) extends zio.aws.appflow.model.StartFlowRequest.ReadOnly {
    override val flowName: FlowName =
      zio.aws.appflow.model.primitives.FlowName(impl.flowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.StartFlowRequest
  ): zio.aws.appflow.model.StartFlowRequest.ReadOnly = new Wrapper(impl)
}
