package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.FlowName
import scala.jdk.CollectionConverters.*
final case class StopFlowRequest(flowName: FlowName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.StopFlowRequest = {
    import StopFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.StopFlowRequest
      .builder()
      .flowName(FlowName.unwrap(flowName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.StopFlowRequest.ReadOnly =
    zio.aws.appflow.model.StopFlowRequest.wrap(buildAwsValue())
}
object StopFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.StopFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.StopFlowRequest =
      zio.aws.appflow.model.StopFlowRequest(flowName)
    def flowName: FlowName
    def getFlowName: ZIO[Any, Nothing, FlowName] = ZIO.succeed(flowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.StopFlowRequest
  ) extends zio.aws.appflow.model.StopFlowRequest.ReadOnly {
    override val flowName: FlowName =
      zio.aws.appflow.model.primitives.FlowName(impl.flowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.StopFlowRequest
  ): zio.aws.appflow.model.StopFlowRequest.ReadOnly = new Wrapper(impl)
}
