package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.{TagValue, TagKey, ARN}
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: ARN,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.TagResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.TagResourceRequest.ReadOnly =
    zio.aws.appflow.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.TagResourceRequest =
      zio.aws.appflow.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ARN
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.TagResourceRequest
  ) extends zio.aws.appflow.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.appflow.model.primitives.ARN(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.appflow.model.primitives
          .TagKey(key) -> zio.aws.appflow.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.TagResourceRequest
  ): zio.aws.appflow.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
