package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait TriggerType {
  def unwrap: software.amazon.awssdk.services.appflow.model.TriggerType
}
object TriggerType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.TriggerType
  ): zio.aws.appflow.model.TriggerType = value match {
    case software.amazon.awssdk.services.appflow.model.TriggerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.TriggerType.SCHEDULED =>
      val r = Scheduled
      r
    case software.amazon.awssdk.services.appflow.model.TriggerType.EVENT =>
      val r = Event
      r
    case software.amazon.awssdk.services.appflow.model.TriggerType.ON_DEMAND =>
      val r = OnDemand
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TriggerType =
      software.amazon.awssdk.services.appflow.model.TriggerType.UNKNOWN_TO_SDK_VERSION
  }
  case object Scheduled extends zio.aws.appflow.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TriggerType =
      software.amazon.awssdk.services.appflow.model.TriggerType.SCHEDULED
  }
  case object Event extends zio.aws.appflow.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TriggerType =
      software.amazon.awssdk.services.appflow.model.TriggerType.EVENT
  }
  case object OnDemand extends zio.aws.appflow.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TriggerType =
      software.amazon.awssdk.services.appflow.model.TriggerType.ON_DEMAND
  }
}
