package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.ConnectorLabel
import scala.jdk.CollectionConverters.*
final case class UnregisterConnectorRequest(
    connectorLabel: ConnectorLabel,
    forceDelete: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest = {
    import UnregisterConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest
      .builder()
      .connectorLabel(ConnectorLabel.unwrap(connectorLabel): java.lang.String)
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.UnregisterConnectorRequest.ReadOnly =
    zio.aws.appflow.model.UnregisterConnectorRequest.wrap(buildAwsValue())
}
object UnregisterConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.UnregisterConnectorRequest =
      zio.aws.appflow.model.UnregisterConnectorRequest(
        connectorLabel,
        forceDelete.map(value => value)
      )
    def connectorLabel: ConnectorLabel
    def forceDelete: Optional[Boolean]
    def getConnectorLabel: ZIO[Any, Nothing, ConnectorLabel] =
      ZIO.succeed(connectorLabel)
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest
  ) extends zio.aws.appflow.model.UnregisterConnectorRequest.ReadOnly {
    override val connectorLabel: ConnectorLabel =
      zio.aws.appflow.model.primitives.ConnectorLabel(impl.connectorLabel())
    override val forceDelete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest
  ): zio.aws.appflow.model.UnregisterConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
