package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.ConnectorProfileName
import scala.jdk.CollectionConverters.*
final case class UpdateConnectorProfileRequest(
    connectorProfileName: ConnectorProfileName,
    connectionMode: zio.aws.appflow.model.ConnectionMode,
    connectorProfileConfig: zio.aws.appflow.model.ConnectorProfileConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest = {
    import UpdateConnectorProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest
      .builder()
      .connectorProfileName(
        ConnectorProfileName.unwrap(connectorProfileName): java.lang.String
      )
      .connectionMode(connectionMode.unwrap)
      .connectorProfileConfig(connectorProfileConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.UpdateConnectorProfileRequest.ReadOnly =
    zio.aws.appflow.model.UpdateConnectorProfileRequest.wrap(buildAwsValue())
}
object UpdateConnectorProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.UpdateConnectorProfileRequest =
      zio.aws.appflow.model.UpdateConnectorProfileRequest(
        connectorProfileName,
        connectionMode,
        connectorProfileConfig.asEditable
      )
    def connectorProfileName: ConnectorProfileName
    def connectionMode: zio.aws.appflow.model.ConnectionMode
    def connectorProfileConfig
        : zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly
    def getConnectorProfileName: ZIO[Any, Nothing, ConnectorProfileName] =
      ZIO.succeed(connectorProfileName)
    def getConnectionMode
        : ZIO[Any, Nothing, zio.aws.appflow.model.ConnectionMode] =
      ZIO.succeed(connectionMode)
    def getConnectorProfileConfig: ZIO[
      Any,
      Nothing,
      zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly
    ] = ZIO.succeed(connectorProfileConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest
  ) extends zio.aws.appflow.model.UpdateConnectorProfileRequest.ReadOnly {
    override val connectorProfileName: ConnectorProfileName =
      zio.aws.appflow.model.primitives
        .ConnectorProfileName(impl.connectorProfileName())
    override val connectionMode: zio.aws.appflow.model.ConnectionMode =
      zio.aws.appflow.model.ConnectionMode.wrap(impl.connectionMode())
    override val connectorProfileConfig
        : zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly =
      zio.aws.appflow.model.ConnectorProfileConfig
        .wrap(impl.connectorProfileConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest
  ): zio.aws.appflow.model.UpdateConnectorProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
