package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFlowResponse(
    flowStatus: Optional[zio.aws.appflow.model.FlowStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.UpdateFlowResponse = {
    import UpdateFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.UpdateFlowResponse
      .builder()
      .optionallyWith(flowStatus.map(value => value.unwrap))(_.flowStatus)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.UpdateFlowResponse.ReadOnly =
    zio.aws.appflow.model.UpdateFlowResponse.wrap(buildAwsValue())
}
object UpdateFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.UpdateFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.UpdateFlowResponse =
      zio.aws.appflow.model.UpdateFlowResponse(flowStatus.map(value => value))
    def flowStatus: Optional[zio.aws.appflow.model.FlowStatus]
    def getFlowStatus: ZIO[Any, AwsError, zio.aws.appflow.model.FlowStatus] =
      AwsError.unwrapOptionField("flowStatus", flowStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.UpdateFlowResponse
  ) extends zio.aws.appflow.model.UpdateFlowResponse.ReadOnly {
    override val flowStatus: Optional[zio.aws.appflow.model.FlowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowStatus())
        .map(value => zio.aws.appflow.model.FlowStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.UpdateFlowResponse
  ): zio.aws.appflow.model.UpdateFlowResponse.ReadOnly = new Wrapper(impl)
}
