package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{BucketPrefix, UpsolverBucketName}
import scala.jdk.CollectionConverters.*
final case class UpsolverDestinationProperties(
    bucketName: UpsolverBucketName,
    bucketPrefix: Optional[BucketPrefix] = Optional.Absent,
    s3OutputFormatConfig: zio.aws.appflow.model.UpsolverS3OutputFormatConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.UpsolverDestinationProperties = {
    import UpsolverDestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.UpsolverDestinationProperties
      .builder()
      .bucketName(UpsolverBucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        bucketPrefix.map(value => BucketPrefix.unwrap(value): java.lang.String)
      )(_.bucketPrefix)
      .s3OutputFormatConfig(s3OutputFormatConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.UpsolverDestinationProperties.ReadOnly =
    zio.aws.appflow.model.UpsolverDestinationProperties.wrap(buildAwsValue())
}
object UpsolverDestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.UpsolverDestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.UpsolverDestinationProperties =
      zio.aws.appflow.model.UpsolverDestinationProperties(
        bucketName,
        bucketPrefix.map(value => value),
        s3OutputFormatConfig.asEditable
      )
    def bucketName: UpsolverBucketName
    def bucketPrefix: Optional[BucketPrefix]
    def s3OutputFormatConfig
        : zio.aws.appflow.model.UpsolverS3OutputFormatConfig.ReadOnly
    def getBucketName: ZIO[Any, Nothing, UpsolverBucketName] =
      ZIO.succeed(bucketName)
    def getBucketPrefix: ZIO[Any, AwsError, BucketPrefix] =
      AwsError.unwrapOptionField("bucketPrefix", bucketPrefix)
    def getS3OutputFormatConfig: ZIO[
      Any,
      Nothing,
      zio.aws.appflow.model.UpsolverS3OutputFormatConfig.ReadOnly
    ] = ZIO.succeed(s3OutputFormatConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.UpsolverDestinationProperties
  ) extends zio.aws.appflow.model.UpsolverDestinationProperties.ReadOnly {
    override val bucketName: UpsolverBucketName =
      zio.aws.appflow.model.primitives.UpsolverBucketName(impl.bucketName())
    override val bucketPrefix: Optional[BucketPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPrefix())
      .map(value => zio.aws.appflow.model.primitives.BucketPrefix(value))
    override val s3OutputFormatConfig
        : zio.aws.appflow.model.UpsolverS3OutputFormatConfig.ReadOnly =
      zio.aws.appflow.model.UpsolverS3OutputFormatConfig
        .wrap(impl.s3OutputFormatConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.UpsolverDestinationProperties
  ): zio.aws.appflow.model.UpsolverDestinationProperties.ReadOnly = new Wrapper(
    impl
  )
}
