package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpsolverS3OutputFormatConfig(
    fileType: Optional[zio.aws.appflow.model.FileType] = Optional.Absent,
    prefixConfig: zio.aws.appflow.model.PrefixConfig,
    aggregationConfig: Optional[zio.aws.appflow.model.AggregationConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.UpsolverS3OutputFormatConfig = {
    import UpsolverS3OutputFormatConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.UpsolverS3OutputFormatConfig
      .builder()
      .optionallyWith(fileType.map(value => value.unwrap))(_.fileType)
      .prefixConfig(prefixConfig.buildAwsValue())
      .optionallyWith(aggregationConfig.map(value => value.buildAwsValue()))(
        _.aggregationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.UpsolverS3OutputFormatConfig.ReadOnly =
    zio.aws.appflow.model.UpsolverS3OutputFormatConfig.wrap(buildAwsValue())
}
object UpsolverS3OutputFormatConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.UpsolverS3OutputFormatConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.UpsolverS3OutputFormatConfig =
      zio.aws.appflow.model.UpsolverS3OutputFormatConfig(
        fileType.map(value => value),
        prefixConfig.asEditable,
        aggregationConfig.map(value => value.asEditable)
      )
    def fileType: Optional[zio.aws.appflow.model.FileType]
    def prefixConfig: zio.aws.appflow.model.PrefixConfig.ReadOnly
    def aggregationConfig
        : Optional[zio.aws.appflow.model.AggregationConfig.ReadOnly]
    def getFileType: ZIO[Any, AwsError, zio.aws.appflow.model.FileType] =
      AwsError.unwrapOptionField("fileType", fileType)
    def getPrefixConfig
        : ZIO[Any, Nothing, zio.aws.appflow.model.PrefixConfig.ReadOnly] =
      ZIO.succeed(prefixConfig)
    def getAggregationConfig
        : ZIO[Any, AwsError, zio.aws.appflow.model.AggregationConfig.ReadOnly] =
      AwsError.unwrapOptionField("aggregationConfig", aggregationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.UpsolverS3OutputFormatConfig
  ) extends zio.aws.appflow.model.UpsolverS3OutputFormatConfig.ReadOnly {
    override val fileType: Optional[zio.aws.appflow.model.FileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileType())
        .map(value => zio.aws.appflow.model.FileType.wrap(value))
    override val prefixConfig: zio.aws.appflow.model.PrefixConfig.ReadOnly =
      zio.aws.appflow.model.PrefixConfig.wrap(impl.prefixConfig())
    override val aggregationConfig
        : Optional[zio.aws.appflow.model.AggregationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationConfig())
        .map(value => zio.aws.appflow.model.AggregationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.UpsolverS3OutputFormatConfig
  ): zio.aws.appflow.model.UpsolverS3OutputFormatConfig.ReadOnly = new Wrapper(
    impl
  )
}
