package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait WriteOperationType {
  def unwrap: software.amazon.awssdk.services.appflow.model.WriteOperationType
}
object WriteOperationType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.WriteOperationType
  ): zio.aws.appflow.model.WriteOperationType = value match {
    case software.amazon.awssdk.services.appflow.model.WriteOperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.WriteOperationType.INSERT =>
      val r = INSERT
      r
    case software.amazon.awssdk.services.appflow.model.WriteOperationType.UPSERT =>
      val r = UPSERT
      r
    case software.amazon.awssdk.services.appflow.model.WriteOperationType.UPDATE =>
      val r = UPDATE
      r
    case software.amazon.awssdk.services.appflow.model.WriteOperationType.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.WriteOperationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.WriteOperationType =
      software.amazon.awssdk.services.appflow.model.WriteOperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object INSERT extends zio.aws.appflow.model.WriteOperationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.WriteOperationType =
      software.amazon.awssdk.services.appflow.model.WriteOperationType.INSERT
  }
  case object UPSERT extends zio.aws.appflow.model.WriteOperationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.WriteOperationType =
      software.amazon.awssdk.services.appflow.model.WriteOperationType.UPSERT
  }
  case object UPDATE extends zio.aws.appflow.model.WriteOperationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.WriteOperationType =
      software.amazon.awssdk.services.appflow.model.WriteOperationType.UPDATE
  }
  case object DELETE extends zio.aws.appflow.model.WriteOperationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.WriteOperationType =
      software.amazon.awssdk.services.appflow.model.WriteOperationType.DELETE
  }
}
