package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{AccessToken, ClientSecret, ClientId}
import scala.jdk.CollectionConverters.*
final case class ZendeskConnectorProfileCredentials(
    clientId: ClientId,
    clientSecret: ClientSecret,
    accessToken: Optional[AccessToken] = Optional.Absent,
    oAuthRequest: Optional[zio.aws.appflow.model.ConnectorOAuthRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ZendeskConnectorProfileCredentials = {
    import ZendeskConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ZendeskConnectorProfileCredentials
      .builder()
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .clientSecret(ClientSecret.unwrap(clientSecret): java.lang.String)
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(oAuthRequest.map(value => value.buildAwsValue()))(
        _.oAuthRequest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.ZendeskConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.ZendeskConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object ZendeskConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ZendeskConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ZendeskConnectorProfileCredentials =
      zio.aws.appflow.model.ZendeskConnectorProfileCredentials(
        clientId,
        clientSecret,
        accessToken.map(value => value),
        oAuthRequest.map(value => value.asEditable)
      )
    def clientId: ClientId
    def clientSecret: ClientSecret
    def accessToken: Optional[AccessToken]
    def oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly]
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
    def getClientSecret: ZIO[Any, Nothing, ClientSecret] =
      ZIO.succeed(clientSecret)
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getOAuthRequest: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthRequest", oAuthRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ZendeskConnectorProfileCredentials
  ) extends zio.aws.appflow.model.ZendeskConnectorProfileCredentials.ReadOnly {
    override val clientId: ClientId =
      zio.aws.appflow.model.primitives.ClientId(impl.clientId())
    override val clientSecret: ClientSecret =
      zio.aws.appflow.model.primitives.ClientSecret(impl.clientSecret())
    override val accessToken: Optional[AccessToken] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value => zio.aws.appflow.model.primitives.AccessToken(value))
    override val oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthRequest())
        .map(value => zio.aws.appflow.model.ConnectorOAuthRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ZendeskConnectorProfileCredentials
  ): zio.aws.appflow.model.ZendeskConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
