package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.OAuthScope
import scala.jdk.CollectionConverters.*
final case class ZendeskMetadata(
    oAuthScopes: Optional[Iterable[OAuthScope]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ZendeskMetadata = {
    import ZendeskMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ZendeskMetadata
      .builder()
      .optionallyWith(
        oAuthScopes.map(value =>
          value.map { item =>
            OAuthScope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.oAuthScopes)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ZendeskMetadata.ReadOnly =
    zio.aws.appflow.model.ZendeskMetadata.wrap(buildAwsValue())
}
object ZendeskMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ZendeskMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ZendeskMetadata =
      zio.aws.appflow.model.ZendeskMetadata(oAuthScopes.map(value => value))
    def oAuthScopes: Optional[List[OAuthScope]]
    def getOAuthScopes: ZIO[Any, AwsError, List[OAuthScope]] =
      AwsError.unwrapOptionField("oAuthScopes", oAuthScopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ZendeskMetadata
  ) extends zio.aws.appflow.model.ZendeskMetadata.ReadOnly {
    override val oAuthScopes: Optional[List[OAuthScope]] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuthScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.OAuthScope(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ZendeskMetadata
  ): zio.aws.appflow.model.ZendeskMetadata.ReadOnly = new Wrapper(impl)
}
