package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.PortNumber
import scala.jdk.CollectionConverters._
final case class ClientPolicyTls(
    certificate: Option[zio.aws.appmesh.model.ClientTlsCertificate] = None,
    enforce: Option[Boolean] = None,
    ports: Option[Iterable[PortNumber]] = None,
    validation: zio.aws.appmesh.model.TlsValidationContext
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ClientPolicyTls = {
    import ClientPolicyTls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ClientPolicyTls
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .optionallyWith(enforce.map(value => value: java.lang.Boolean))(_.enforce)
      .optionallyWith(
        ports.map(value =>
          value.map { item =>
            PortNumber.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.ports)
      .validation(validation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ClientPolicyTls.ReadOnly =
    zio.aws.appmesh.model.ClientPolicyTls.wrap(buildAwsValue())
}
object ClientPolicyTls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ClientPolicyTls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ClientPolicyTls =
      zio.aws.appmesh.model.ClientPolicyTls(
        certificate.map(value => value.asEditable),
        enforce.map(value => value),
        ports.map(value => value),
        validation.asEditable
      )
    def certificate: Option[zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly]
    def enforce: Option[Boolean]
    def ports: Option[List[PortNumber]]
    def validation: zio.aws.appmesh.model.TlsValidationContext.ReadOnly
    def getCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("certificate", certificate)
    def getEnforce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enforce", enforce)
    def getPorts: ZIO[Any, AwsError, List[PortNumber]] =
      AwsError.unwrapOptionField("ports", ports)
    def getValidation: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.TlsValidationContext.ReadOnly
    ] = ZIO.succeed(validation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ClientPolicyTls
  ) extends zio.aws.appmesh.model.ClientPolicyTls.ReadOnly {
    override val certificate
        : Option[zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.appmesh.model.ClientTlsCertificate.wrap(value))
    override val enforce: Option[Boolean] =
      scala.Option(impl.enforce()).map(value => value: Boolean)
    override val ports: Option[List[PortNumber]] = scala
      .Option(impl.ports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.primitives.PortNumber(item)
        }.toList
      )
    override val validation
        : zio.aws.appmesh.model.TlsValidationContext.ReadOnly =
      zio.aws.appmesh.model.TlsValidationContext.wrap(impl.validation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ClientPolicyTls
  ): zio.aws.appmesh.model.ClientPolicyTls.ReadOnly = new Wrapper(impl)
}
