package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVirtualNodeResponse(
    virtualNode: zio.aws.appmesh.model.VirtualNodeData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeResponse = {
    import DeleteVirtualNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeResponse
      .builder()
      .virtualNode(virtualNode.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteVirtualNodeResponse.ReadOnly =
    zio.aws.appmesh.model.DeleteVirtualNodeResponse.wrap(buildAwsValue())
}
object DeleteVirtualNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteVirtualNodeResponse =
      zio.aws.appmesh.model.DeleteVirtualNodeResponse(virtualNode.asEditable)
    def virtualNode: zio.aws.appmesh.model.VirtualNodeData.ReadOnly
    def getVirtualNode
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeData.ReadOnly] =
      ZIO.succeed(virtualNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeResponse
  ) extends zio.aws.appmesh.model.DeleteVirtualNodeResponse.ReadOnly {
    override val virtualNode: zio.aws.appmesh.model.VirtualNodeData.ReadOnly =
      zio.aws.appmesh.model.VirtualNodeData.wrap(impl.virtualNode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeResponse
  ): zio.aws.appmesh.model.DeleteVirtualNodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
