package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVirtualNodeResponse(
    virtualNode: zio.aws.appmesh.model.VirtualNodeData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeResponse = {
    import DescribeVirtualNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeResponse
      .builder()
      .virtualNode(virtualNode.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DescribeVirtualNodeResponse.ReadOnly =
    zio.aws.appmesh.model.DescribeVirtualNodeResponse.wrap(buildAwsValue())
}
object DescribeVirtualNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeVirtualNodeResponse =
      zio.aws.appmesh.model.DescribeVirtualNodeResponse(virtualNode.asEditable)
    def virtualNode: zio.aws.appmesh.model.VirtualNodeData.ReadOnly
    def getVirtualNode
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeData.ReadOnly] =
      ZIO.succeed(virtualNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeResponse
  ) extends zio.aws.appmesh.model.DescribeVirtualNodeResponse.ReadOnly {
    override val virtualNode: zio.aws.appmesh.model.VirtualNodeData.ReadOnly =
      zio.aws.appmesh.model.VirtualNodeData.wrap(impl.virtualNode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeResponse
  ): zio.aws.appmesh.model.DescribeVirtualNodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
