package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.HeaderName
import scala.jdk.CollectionConverters._
final case class HttpGatewayRouteHeader(
    invert: Option[Boolean] = None,
    `match`: Option[zio.aws.appmesh.model.HeaderMatchMethod] = None,
    name: HeaderName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteHeader = {
    import HttpGatewayRouteHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteHeader
      .builder()
      .optionallyWith(invert.map(value => value: java.lang.Boolean))(_.invert)
      .optionallyWith(`match`.map(value => value.buildAwsValue()))(_.`match`)
      .name(HeaderName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpGatewayRouteHeader.ReadOnly =
    zio.aws.appmesh.model.HttpGatewayRouteHeader.wrap(buildAwsValue())
}
object HttpGatewayRouteHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpGatewayRouteHeader =
      zio.aws.appmesh.model.HttpGatewayRouteHeader(
        invert.map(value => value),
        `match`.map(value => value.asEditable),
        name
      )
    def invert: Option[Boolean]
    def `match`: Option[zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly]
    def name: HeaderName
    def getInvert: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("invert", invert)
    def getMatch
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly] =
      AwsError.unwrapOptionField("match", `match`)
    def getName: ZIO[Any, Nothing, HeaderName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteHeader
  ) extends zio.aws.appmesh.model.HttpGatewayRouteHeader.ReadOnly {
    override val invert: Option[Boolean] =
      scala.Option(impl.invert()).map(value => value: Boolean)
    override val `match`
        : Option[zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly] = scala
      .Option(impl.`match`())
      .map(value => zio.aws.appmesh.model.HeaderMatchMethod.wrap(value))
    override val name: HeaderName =
      zio.aws.appmesh.model.primitives.HeaderName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteHeader
  ): zio.aws.appmesh.model.HttpGatewayRouteHeader.ReadOnly = new Wrapper(impl)
}
