package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  ListRoutesLimit
}
import scala.jdk.CollectionConverters._
final case class ListRoutesRequest(
    limit: Option[ListRoutesLimit] = None,
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    nextToken: Option[String] = None,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListRoutesRequest = {
    import ListRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListRoutesRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListRoutesLimit.unwrap(value): Integer)
      )(_.limit)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListRoutesRequest.ReadOnly =
    zio.aws.appmesh.model.ListRoutesRequest.wrap(buildAwsValue())
}
object ListRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListRoutesRequest =
      zio.aws.appmesh.model.ListRoutesRequest(
        limit.map(value => value),
        meshName,
        meshOwner.map(value => value),
        nextToken.map(value => value),
        virtualRouterName
      )
    def limit: Option[ListRoutesLimit]
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def nextToken: Option[String]
    def virtualRouterName: ResourceName
    def getLimit: ZIO[Any, AwsError, ListRoutesLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListRoutesRequest
  ) extends zio.aws.appmesh.model.ListRoutesRequest.ReadOnly {
    override val limit: Option[ListRoutesLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.appmesh.model.primitives.ListRoutesLimit(value))
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListRoutesRequest
  ): zio.aws.appmesh.model.ListRoutesRequest.ReadOnly = new Wrapper(impl)
}
