package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRoutesResponse(
    nextToken: Option[String] = None,
    routes: Iterable[zio.aws.appmesh.model.RouteRef]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListRoutesResponse = {
    import ListRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListRoutesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .routes(routes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListRoutesResponse.ReadOnly =
    zio.aws.appmesh.model.ListRoutesResponse.wrap(buildAwsValue())
}
object ListRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListRoutesResponse =
      zio.aws.appmesh.model.ListRoutesResponse(
        nextToken.map(value => value),
        routes.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[String]
    def routes: List[zio.aws.appmesh.model.RouteRef.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoutes
        : ZIO[Any, Nothing, List[zio.aws.appmesh.model.RouteRef.ReadOnly]] =
      ZIO.succeed(routes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListRoutesResponse
  ) extends zio.aws.appmesh.model.ListRoutesResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val routes: List[zio.aws.appmesh.model.RouteRef.ReadOnly] = impl
      .routes()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.RouteRef.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListRoutesResponse
  ): zio.aws.appmesh.model.ListRoutesResponse.ReadOnly = new Wrapper(impl)
}
