package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  ListVirtualNodesLimit
}
import scala.jdk.CollectionConverters._
final case class ListVirtualNodesRequest(
    limit: Option[ListVirtualNodesLimit] = None,
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest = {
    import ListVirtualNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListVirtualNodesLimit.unwrap(value): Integer)
      )(_.limit)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListVirtualNodesRequest.ReadOnly =
    zio.aws.appmesh.model.ListVirtualNodesRequest.wrap(buildAwsValue())
}
object ListVirtualNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListVirtualNodesRequest =
      zio.aws.appmesh.model.ListVirtualNodesRequest(
        limit.map(value => value),
        meshName,
        meshOwner.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Option[ListVirtualNodesLimit]
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def nextToken: Option[String]
    def getLimit: ZIO[Any, AwsError, ListVirtualNodesLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest
  ) extends zio.aws.appmesh.model.ListVirtualNodesRequest.ReadOnly {
    override val limit: Option[ListVirtualNodesLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.appmesh.model.primitives.ListVirtualNodesLimit(value)
      )
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest
  ): zio.aws.appmesh.model.ListVirtualNodesRequest.ReadOnly = new Wrapper(impl)
}
