package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class ListenerTlsAcmCertificate(certificateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTlsAcmCertificate = {
    import ListenerTlsAcmCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTlsAcmCertificate
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly =
    zio.aws.appmesh.model.ListenerTlsAcmCertificate.wrap(buildAwsValue())
}
object ListenerTlsAcmCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTlsAcmCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTlsAcmCertificate =
      zio.aws.appmesh.model.ListenerTlsAcmCertificate(certificateArn)
    def certificateArn: Arn
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsAcmCertificate
  ) extends zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.appmesh.model.primitives.Arn(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsAcmCertificate
  ): zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly = new Wrapper(
    impl
  )
}
