package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListenerTlsCertificate(
    acm: Option[zio.aws.appmesh.model.ListenerTlsAcmCertificate] = None,
    file: Option[zio.aws.appmesh.model.ListenerTlsFileCertificate] = None,
    sds: Option[zio.aws.appmesh.model.ListenerTlsSdsCertificate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate = {
    import ListenerTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate
      .builder()
      .optionallyWith(acm.map(value => value.buildAwsValue()))(_.acm)
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly =
    zio.aws.appmesh.model.ListenerTlsCertificate.wrap(buildAwsValue())
}
object ListenerTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTlsCertificate =
      zio.aws.appmesh.model.ListenerTlsCertificate(
        acm.map(value => value.asEditable),
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def acm: Option[zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly]
    def file: Option[zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly]
    def sds: Option[zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly]
    def getAcm: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("acm", acm)
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate
  ) extends zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly {
    override val acm
        : Option[zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly] =
      scala
        .Option(impl.acm())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsAcmCertificate.wrap(value)
        )
    override val file
        : Option[zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly] =
      scala
        .Option(impl.file())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsFileCertificate.wrap(value)
        )
    override val sds
        : Option[zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly] =
      scala
        .Option(impl.sds())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsSdsCertificate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate
  ): zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly = new Wrapper(impl)
}
