package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateMeshResponse(mesh: zio.aws.appmesh.model.MeshData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateMeshResponse = {
    import UpdateMeshResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateMeshResponse
      .builder()
      .mesh(mesh.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateMeshResponse.ReadOnly =
    zio.aws.appmesh.model.UpdateMeshResponse.wrap(buildAwsValue())
}
object UpdateMeshResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateMeshResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateMeshResponse =
      zio.aws.appmesh.model.UpdateMeshResponse(mesh.asEditable)
    def mesh: zio.aws.appmesh.model.MeshData.ReadOnly
    def getMesh: ZIO[Any, Nothing, zio.aws.appmesh.model.MeshData.ReadOnly] =
      ZIO.succeed(mesh)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateMeshResponse
  ) extends zio.aws.appmesh.model.UpdateMeshResponse.ReadOnly {
    override val mesh: zio.aws.appmesh.model.MeshData.ReadOnly =
      zio.aws.appmesh.model.MeshData.wrap(impl.mesh())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateMeshResponse
  ): zio.aws.appmesh.model.UpdateMeshResponse.ReadOnly = new Wrapper(impl)
}
