package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.PortNumber
import scala.jdk.CollectionConverters._
final case class VirtualGatewayPortMapping(
    port: PortNumber,
    protocol: zio.aws.appmesh.model.VirtualGatewayPortProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortMapping = {
    import VirtualGatewayPortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortMapping
      .builder()
      .port(PortNumber.unwrap(port): Integer)
      .protocol(protocol.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayPortMapping.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayPortMapping.wrap(buildAwsValue())
}
object VirtualGatewayPortMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayPortMapping =
      zio.aws.appmesh.model.VirtualGatewayPortMapping(port, protocol)
    def port: PortNumber
    def protocol: zio.aws.appmesh.model.VirtualGatewayPortProtocol
    def getPort: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(port)
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualGatewayPortProtocol] =
      ZIO.succeed(protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortMapping
  ) extends zio.aws.appmesh.model.VirtualGatewayPortMapping.ReadOnly {
    override val port: PortNumber =
      zio.aws.appmesh.model.primitives.PortNumber(impl.port())
    override val protocol: zio.aws.appmesh.model.VirtualGatewayPortProtocol =
      zio.aws.appmesh.model.VirtualGatewayPortProtocol.wrap(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortMapping
  ): zio.aws.appmesh.model.VirtualGatewayPortMapping.ReadOnly = new Wrapper(
    impl
  )
}
