package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VirtualServiceStatus(
    status: zio.aws.appmesh.model.VirtualServiceStatusCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualServiceStatus = {
    import VirtualServiceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualServiceStatus
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualServiceStatus.ReadOnly =
    zio.aws.appmesh.model.VirtualServiceStatus.wrap(buildAwsValue())
}
object VirtualServiceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualServiceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualServiceStatus =
      zio.aws.appmesh.model.VirtualServiceStatus(status)
    def status: zio.aws.appmesh.model.VirtualServiceStatusCode
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualServiceStatusCode] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceStatus
  ) extends zio.aws.appmesh.model.VirtualServiceStatus.ReadOnly {
    override val status: zio.aws.appmesh.model.VirtualServiceStatusCode =
      zio.aws.appmesh.model.VirtualServiceStatusCode.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceStatus
  ): zio.aws.appmesh.model.VirtualServiceStatus.ReadOnly = new Wrapper(impl)
}
