package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Backend(
    virtualService: Optional[zio.aws.appmesh.model.VirtualServiceBackend] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.appmesh.model.Backend = {
    import Backend.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.Backend
      .builder()
      .optionallyWith(virtualService.map(value => value.buildAwsValue()))(
        _.virtualService
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.Backend.ReadOnly =
    zio.aws.appmesh.model.Backend.wrap(buildAwsValue())
}
object Backend {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.Backend] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.Backend = zio.aws.appmesh.model
      .Backend(virtualService.map(value => value.asEditable))
    def virtualService
        : Optional[zio.aws.appmesh.model.VirtualServiceBackend.ReadOnly]
    def getVirtualService: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualServiceBackend.ReadOnly
    ] = AwsError.unwrapOptionField("virtualService", virtualService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.Backend
  ) extends zio.aws.appmesh.model.Backend.ReadOnly {
    override val virtualService
        : Optional[zio.aws.appmesh.model.VirtualServiceBackend.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualService())
        .map(value => zio.aws.appmesh.model.VirtualServiceBackend.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.Backend
  ): zio.aws.appmesh.model.Backend.ReadOnly = new Wrapper(impl)
}
