package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters._
final case class CreateGatewayRouteRequest(
    clientToken: Optional[String] = Optional.Absent,
    gatewayRouteName: ResourceName,
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    spec: zio.aws.appmesh.model.GatewayRouteSpec,
    tags: Optional[Iterable[zio.aws.appmesh.model.TagRef]] = Optional.Absent,
    virtualGatewayName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest = {
    import CreateGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .gatewayRouteName(ResourceName.unwrap(gatewayRouteName): java.lang.String)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .spec(spec.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .virtualGatewayName(
        ResourceName.unwrap(virtualGatewayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateGatewayRouteRequest.ReadOnly =
    zio.aws.appmesh.model.CreateGatewayRouteRequest.wrap(buildAwsValue())
}
object CreateGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateGatewayRouteRequest =
      zio.aws.appmesh.model.CreateGatewayRouteRequest(
        clientToken.map(value => value),
        gatewayRouteName,
        meshName,
        meshOwner.map(value => value),
        spec.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        virtualGatewayName
      )
    def clientToken: Optional[String]
    def gatewayRouteName: ResourceName
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def spec: zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly
    def tags: Optional[List[zio.aws.appmesh.model.TagRef.ReadOnly]]
    def virtualGatewayName: ResourceName
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getGatewayRouteName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(gatewayRouteName)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVirtualGatewayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest
  ) extends zio.aws.appmesh.model.CreateGatewayRouteRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val gatewayRouteName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.gatewayRouteName())
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val spec: zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly =
      zio.aws.appmesh.model.GatewayRouteSpec.wrap(impl.spec())
    override val tags: Optional[List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.TagRef.wrap(item)
          }.toList
        )
    override val virtualGatewayName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest
  ): zio.aws.appmesh.model.CreateGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
