package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateRouteResponse(route: zio.aws.appmesh.model.RouteData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateRouteResponse = {
    import CreateRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateRouteResponse
      .builder()
      .route(route.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateRouteResponse.ReadOnly =
    zio.aws.appmesh.model.CreateRouteResponse.wrap(buildAwsValue())
}
object CreateRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateRouteResponse =
      zio.aws.appmesh.model.CreateRouteResponse(route.asEditable)
    def route: zio.aws.appmesh.model.RouteData.ReadOnly
    def getRoute: ZIO[Any, Nothing, zio.aws.appmesh.model.RouteData.ReadOnly] =
      ZIO.succeed(route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateRouteResponse
  ) extends zio.aws.appmesh.model.CreateRouteResponse.ReadOnly {
    override val route: zio.aws.appmesh.model.RouteData.ReadOnly =
      zio.aws.appmesh.model.RouteData.wrap(impl.route())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateRouteResponse
  ): zio.aws.appmesh.model.CreateRouteResponse.ReadOnly = new Wrapper(impl)
}
