package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DeleteMeshRequest(meshName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest = {
    import DeleteMeshRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteMeshRequest.ReadOnly =
    zio.aws.appmesh.model.DeleteMeshRequest.wrap(buildAwsValue())
}
object DeleteMeshRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteMeshRequest =
      zio.aws.appmesh.model.DeleteMeshRequest(meshName)
    def meshName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest
  ) extends zio.aws.appmesh.model.DeleteMeshRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest
  ): zio.aws.appmesh.model.DeleteMeshRequest.ReadOnly = new Wrapper(impl)
}
