package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters._
final case class DeleteVirtualNodeRequest(
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    virtualNodeName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest = {
    import DeleteVirtualNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .virtualNodeName(ResourceName.unwrap(virtualNodeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteVirtualNodeRequest.ReadOnly =
    zio.aws.appmesh.model.DeleteVirtualNodeRequest.wrap(buildAwsValue())
}
object DeleteVirtualNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteVirtualNodeRequest =
      zio.aws.appmesh.model.DeleteVirtualNodeRequest(
        meshName,
        meshOwner.map(value => value),
        virtualNodeName
      )
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def virtualNodeName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getVirtualNodeName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualNodeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest
  ) extends zio.aws.appmesh.model.DeleteVirtualNodeRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val virtualNodeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualNodeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest
  ): zio.aws.appmesh.model.DeleteVirtualNodeRequest.ReadOnly = new Wrapper(impl)
}
