package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVirtualGatewayResponse(
    virtualGateway: zio.aws.appmesh.model.VirtualGatewayData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayResponse = {
    import DescribeVirtualGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayResponse
      .builder()
      .virtualGateway(virtualGateway.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.DescribeVirtualGatewayResponse.ReadOnly =
    zio.aws.appmesh.model.DescribeVirtualGatewayResponse.wrap(buildAwsValue())
}
object DescribeVirtualGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeVirtualGatewayResponse =
      zio.aws.appmesh.model
        .DescribeVirtualGatewayResponse(virtualGateway.asEditable)
    def virtualGateway: zio.aws.appmesh.model.VirtualGatewayData.ReadOnly
    def getVirtualGateway
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualGatewayData.ReadOnly] =
      ZIO.succeed(virtualGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayResponse
  ) extends zio.aws.appmesh.model.DescribeVirtualGatewayResponse.ReadOnly {
    override val virtualGateway
        : zio.aws.appmesh.model.VirtualGatewayData.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewayData.wrap(impl.virtualGateway())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayResponse
  ): zio.aws.appmesh.model.DescribeVirtualGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
