package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVirtualRouterResponse(
    virtualRouter: zio.aws.appmesh.model.VirtualRouterData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterResponse = {
    import DescribeVirtualRouterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterResponse
      .builder()
      .virtualRouter(virtualRouter.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DescribeVirtualRouterResponse.ReadOnly =
    zio.aws.appmesh.model.DescribeVirtualRouterResponse.wrap(buildAwsValue())
}
object DescribeVirtualRouterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeVirtualRouterResponse =
      zio.aws.appmesh.model
        .DescribeVirtualRouterResponse(virtualRouter.asEditable)
    def virtualRouter: zio.aws.appmesh.model.VirtualRouterData.ReadOnly
    def getVirtualRouter
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualRouterData.ReadOnly] =
      ZIO.succeed(virtualRouter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterResponse
  ) extends zio.aws.appmesh.model.DescribeVirtualRouterResponse.ReadOnly {
    override val virtualRouter
        : zio.aws.appmesh.model.VirtualRouterData.ReadOnly =
      zio.aws.appmesh.model.VirtualRouterData.wrap(impl.virtualRouter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterResponse
  ): zio.aws.appmesh.model.DescribeVirtualRouterResponse.ReadOnly = new Wrapper(
    impl
  )
}
