package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class GatewayRouteData(
    gatewayRouteName: ResourceName,
    meshName: ResourceName,
    metadata: zio.aws.appmesh.model.ResourceMetadata,
    spec: zio.aws.appmesh.model.GatewayRouteSpec,
    status: zio.aws.appmesh.model.GatewayRouteStatus,
    virtualGatewayName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteData = {
    import GatewayRouteData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteData
      .builder()
      .gatewayRouteName(ResourceName.unwrap(gatewayRouteName): java.lang.String)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .metadata(metadata.buildAwsValue())
      .spec(spec.buildAwsValue())
      .status(status.buildAwsValue())
      .virtualGatewayName(
        ResourceName.unwrap(virtualGatewayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteData.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteData.wrap(buildAwsValue())
}
object GatewayRouteData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteData =
      zio.aws.appmesh.model.GatewayRouteData(
        gatewayRouteName,
        meshName,
        metadata.asEditable,
        spec.asEditable,
        status.asEditable,
        virtualGatewayName
      )
    def gatewayRouteName: ResourceName
    def meshName: ResourceName
    def metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly
    def spec: zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly
    def status: zio.aws.appmesh.model.GatewayRouteStatus.ReadOnly
    def virtualGatewayName: ResourceName
    def getGatewayRouteName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(gatewayRouteName)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMetadata
        : ZIO[Any, Nothing, zio.aws.appmesh.model.ResourceMetadata.ReadOnly] =
      ZIO.succeed(metadata)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.GatewayRouteStatus.ReadOnly] =
      ZIO.succeed(status)
    def getVirtualGatewayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteData
  ) extends zio.aws.appmesh.model.GatewayRouteData.ReadOnly {
    override val gatewayRouteName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.gatewayRouteName())
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly =
      zio.aws.appmesh.model.ResourceMetadata.wrap(impl.metadata())
    override val spec: zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly =
      zio.aws.appmesh.model.GatewayRouteSpec.wrap(impl.spec())
    override val status: zio.aws.appmesh.model.GatewayRouteStatus.ReadOnly =
      zio.aws.appmesh.model.GatewayRouteStatus.wrap(impl.status())
    override val virtualGatewayName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteData
  ): zio.aws.appmesh.model.GatewayRouteData.ReadOnly = new Wrapper(impl)
}
