package zio.aws.appmesh.model
import scala.jdk.CollectionConverters._
sealed trait GrpcRetryPolicyEvent {
  def unwrap: software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent
}
object GrpcRetryPolicyEvent {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent
  ): zio.aws.appmesh.model.GrpcRetryPolicyEvent = value match {
    case software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.DEADLINE_EXCEEDED =>
      val r = `deadline-exceeded`
      r
    case software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.INTERNAL =>
      val r = internal
      r
    case software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.RESOURCE_EXHAUSTED =>
      val r = `resource-exhausted`
      r
    case software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.UNAVAILABLE =>
      val r = unavailable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.GrpcRetryPolicyEvent {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent =
      software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object cancelled extends zio.aws.appmesh.model.GrpcRetryPolicyEvent {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent =
      software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.CANCELLED
  }
  case object `deadline-exceeded`
      extends zio.aws.appmesh.model.GrpcRetryPolicyEvent {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent =
      software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.DEADLINE_EXCEEDED
  }
  case object internal extends zio.aws.appmesh.model.GrpcRetryPolicyEvent {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent =
      software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.INTERNAL
  }
  case object `resource-exhausted`
      extends zio.aws.appmesh.model.GrpcRetryPolicyEvent {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent =
      software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.RESOURCE_EXHAUSTED
  }
  case object unavailable extends zio.aws.appmesh.model.GrpcRetryPolicyEvent {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent =
      software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent.UNAVAILABLE
  }
}
