package zio.aws.appmesh.model
import scala.jdk.CollectionConverters._
sealed trait HttpScheme {
  def unwrap: software.amazon.awssdk.services.appmesh.model.HttpScheme
}
object HttpScheme {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.HttpScheme
  ): zio.aws.appmesh.model.HttpScheme = value match {
    case software.amazon.awssdk.services.appmesh.model.HttpScheme.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.HttpScheme.HTTP =>
      val r = http
      r
    case software.amazon.awssdk.services.appmesh.model.HttpScheme.HTTPS =>
      val r = https
      r
  }
  case object unknownToSdkVersion extends zio.aws.appmesh.model.HttpScheme {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpScheme =
      software.amazon.awssdk.services.appmesh.model.HttpScheme.UNKNOWN_TO_SDK_VERSION
  }
  case object http extends zio.aws.appmesh.model.HttpScheme {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpScheme =
      software.amazon.awssdk.services.appmesh.model.HttpScheme.HTTP
  }
  case object https extends zio.aws.appmesh.model.HttpScheme {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpScheme =
      software.amazon.awssdk.services.appmesh.model.HttpScheme.HTTPS
  }
}
