package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVirtualServicesResponse(
    nextToken: Optional[String] = Optional.Absent,
    virtualServices: Iterable[zio.aws.appmesh.model.VirtualServiceRef]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse = {
    import ListVirtualServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .virtualServices(virtualServices.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListVirtualServicesResponse.ReadOnly =
    zio.aws.appmesh.model.ListVirtualServicesResponse.wrap(buildAwsValue())
}
object ListVirtualServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListVirtualServicesResponse =
      zio.aws.appmesh.model.ListVirtualServicesResponse(
        nextToken.map(value => value),
        virtualServices.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def virtualServices: List[zio.aws.appmesh.model.VirtualServiceRef.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualServices: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.VirtualServiceRef.ReadOnly
    ]] = ZIO.succeed(virtualServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse
  ) extends zio.aws.appmesh.model.ListVirtualServicesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val virtualServices
        : List[zio.aws.appmesh.model.VirtualServiceRef.ReadOnly] = impl
      .virtualServices()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.VirtualServiceRef.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse
  ): zio.aws.appmesh.model.ListVirtualServicesResponse.ReadOnly = new Wrapper(
    impl
  )
}
