package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.SubjectAlternativeName
import scala.jdk.CollectionConverters._
final case class SubjectAlternativeNameMatchers(
    exact: Iterable[SubjectAlternativeName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.SubjectAlternativeNameMatchers = {
    import SubjectAlternativeNameMatchers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.SubjectAlternativeNameMatchers
      .builder()
      .exact(exact.map { item =>
        SubjectAlternativeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.SubjectAlternativeNameMatchers.ReadOnly =
    zio.aws.appmesh.model.SubjectAlternativeNameMatchers.wrap(buildAwsValue())
}
object SubjectAlternativeNameMatchers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.SubjectAlternativeNameMatchers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.SubjectAlternativeNameMatchers =
      zio.aws.appmesh.model.SubjectAlternativeNameMatchers(exact)
    def exact: List[SubjectAlternativeName]
    def getExact: ZIO[Any, Nothing, List[SubjectAlternativeName]] =
      ZIO.succeed(exact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.SubjectAlternativeNameMatchers
  ) extends zio.aws.appmesh.model.SubjectAlternativeNameMatchers.ReadOnly {
    override val exact: List[SubjectAlternativeName] = impl
      .exact()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.primitives.SubjectAlternativeName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.SubjectAlternativeNameMatchers
  ): zio.aws.appmesh.model.SubjectAlternativeNameMatchers.ReadOnly =
    new Wrapper(impl)
}
