package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.appmesh.model.TagRef]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TagResourceRequest.ReadOnly =
    zio.aws.appmesh.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TagResourceRequest =
      zio.aws.appmesh.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.appmesh.model.TagRef.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TagResourceRequest
  ) extends zio.aws.appmesh.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.appmesh.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.appmesh.model.TagRef.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.TagRef.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TagResourceRequest
  ): zio.aws.appmesh.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
