package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class TlsValidationContextAcmTrust(
    certificateAuthorityArns: Iterable[Arn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TlsValidationContextAcmTrust = {
    import TlsValidationContextAcmTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextAcmTrust
      .builder()
      .certificateAuthorityArns(certificateAuthorityArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly =
    zio.aws.appmesh.model.TlsValidationContextAcmTrust.wrap(buildAwsValue())
}
object TlsValidationContextAcmTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextAcmTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TlsValidationContextAcmTrust =
      zio.aws.appmesh.model
        .TlsValidationContextAcmTrust(certificateAuthorityArns)
    def certificateAuthorityArns: List[Arn]
    def getCertificateAuthorityArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(certificateAuthorityArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextAcmTrust
  ) extends zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly {
    override val certificateAuthorityArns: List[Arn] = impl
      .certificateAuthorityArns()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextAcmTrust
  ): zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly = new Wrapper(
    impl
  )
}
