package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class VirtualGatewayData(
    meshName: ResourceName,
    metadata: zio.aws.appmesh.model.ResourceMetadata,
    spec: zio.aws.appmesh.model.VirtualGatewaySpec,
    status: zio.aws.appmesh.model.VirtualGatewayStatus,
    virtualGatewayName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayData = {
    import VirtualGatewayData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayData
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .metadata(metadata.buildAwsValue())
      .spec(spec.buildAwsValue())
      .status(status.buildAwsValue())
      .virtualGatewayName(
        ResourceName.unwrap(virtualGatewayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayData.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayData.wrap(buildAwsValue())
}
object VirtualGatewayData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayData =
      zio.aws.appmesh.model.VirtualGatewayData(
        meshName,
        metadata.asEditable,
        spec.asEditable,
        status.asEditable,
        virtualGatewayName
      )
    def meshName: ResourceName
    def metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly
    def spec: zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly
    def status: zio.aws.appmesh.model.VirtualGatewayStatus.ReadOnly
    def virtualGatewayName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMetadata
        : ZIO[Any, Nothing, zio.aws.appmesh.model.ResourceMetadata.ReadOnly] =
      ZIO.succeed(metadata)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly] =
      ZIO.succeed(spec)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualGatewayStatus.ReadOnly
    ] = ZIO.succeed(status)
    def getVirtualGatewayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayData
  ) extends zio.aws.appmesh.model.VirtualGatewayData.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly =
      zio.aws.appmesh.model.ResourceMetadata.wrap(impl.metadata())
    override val spec: zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewaySpec.wrap(impl.spec())
    override val status: zio.aws.appmesh.model.VirtualGatewayStatus.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewayStatus.wrap(impl.status())
    override val virtualGatewayName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayData
  ): zio.aws.appmesh.model.VirtualGatewayData.ReadOnly = new Wrapper(impl)
}
