package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{
  VirtualGatewayHealthCheckTimeoutMillis,
  PortNumber,
  VirtualGatewayHealthCheckIntervalMillis,
  VirtualGatewayHealthCheckThreshold
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class VirtualGatewayHealthCheckPolicy(
    healthyThreshold: VirtualGatewayHealthCheckThreshold,
    intervalMillis: VirtualGatewayHealthCheckIntervalMillis,
    path: Optional[String] = Optional.Absent,
    port: Optional[PortNumber] = Optional.Absent,
    protocol: zio.aws.appmesh.model.VirtualGatewayPortProtocol,
    timeoutMillis: VirtualGatewayHealthCheckTimeoutMillis,
    unhealthyThreshold: VirtualGatewayHealthCheckThreshold
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayHealthCheckPolicy = {
    import VirtualGatewayHealthCheckPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayHealthCheckPolicy
      .builder()
      .healthyThreshold(
        VirtualGatewayHealthCheckThreshold.unwrap(healthyThreshold): Integer
      )
      .intervalMillis(
        VirtualGatewayHealthCheckIntervalMillis.unwrap(
          intervalMillis
        ): java.lang.Long
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(port.map(value => PortNumber.unwrap(value): Integer))(
        _.port
      )
      .protocol(protocol.unwrap)
      .timeoutMillis(
        VirtualGatewayHealthCheckTimeoutMillis.unwrap(
          timeoutMillis
        ): java.lang.Long
      )
      .unhealthyThreshold(
        VirtualGatewayHealthCheckThreshold.unwrap(unhealthyThreshold): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy.wrap(buildAwsValue())
}
object VirtualGatewayHealthCheckPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayHealthCheckPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy =
      zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy(
        healthyThreshold,
        intervalMillis,
        path.map(value => value),
        port.map(value => value),
        protocol,
        timeoutMillis,
        unhealthyThreshold
      )
    def healthyThreshold: VirtualGatewayHealthCheckThreshold
    def intervalMillis: VirtualGatewayHealthCheckIntervalMillis
    def path: Optional[String]
    def port: Optional[PortNumber]
    def protocol: zio.aws.appmesh.model.VirtualGatewayPortProtocol
    def timeoutMillis: VirtualGatewayHealthCheckTimeoutMillis
    def unhealthyThreshold: VirtualGatewayHealthCheckThreshold
    def getHealthyThreshold
        : ZIO[Any, Nothing, VirtualGatewayHealthCheckThreshold] =
      ZIO.succeed(healthyThreshold)
    def getIntervalMillis
        : ZIO[Any, Nothing, VirtualGatewayHealthCheckIntervalMillis] =
      ZIO.succeed(intervalMillis)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualGatewayPortProtocol] =
      ZIO.succeed(protocol)
    def getTimeoutMillis
        : ZIO[Any, Nothing, VirtualGatewayHealthCheckTimeoutMillis] =
      ZIO.succeed(timeoutMillis)
    def getUnhealthyThreshold
        : ZIO[Any, Nothing, VirtualGatewayHealthCheckThreshold] =
      ZIO.succeed(unhealthyThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayHealthCheckPolicy
  ) extends zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy.ReadOnly {
    override val healthyThreshold: VirtualGatewayHealthCheckThreshold =
      zio.aws.appmesh.model.primitives
        .VirtualGatewayHealthCheckThreshold(impl.healthyThreshold())
    override val intervalMillis: VirtualGatewayHealthCheckIntervalMillis =
      zio.aws.appmesh.model.primitives
        .VirtualGatewayHealthCheckIntervalMillis(impl.intervalMillis())
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val port: Optional[PortNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.appmesh.model.primitives.PortNumber(value))
    override val protocol: zio.aws.appmesh.model.VirtualGatewayPortProtocol =
      zio.aws.appmesh.model.VirtualGatewayPortProtocol.wrap(impl.protocol())
    override val timeoutMillis: VirtualGatewayHealthCheckTimeoutMillis =
      zio.aws.appmesh.model.primitives
        .VirtualGatewayHealthCheckTimeoutMillis(impl.timeoutMillis())
    override val unhealthyThreshold: VirtualGatewayHealthCheckThreshold =
      zio.aws.appmesh.model.primitives
        .VirtualGatewayHealthCheckThreshold(impl.unhealthyThreshold())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayHealthCheckPolicy
  ): zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy.ReadOnly =
    new Wrapper(impl)
}
