package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VirtualGatewayListenerTlsValidationContext(
    subjectAlternativeNames: Optional[
      zio.aws.appmesh.model.SubjectAlternativeNames
    ] = Optional.Absent,
    trust: zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContext = {
    import VirtualGatewayListenerTlsValidationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContext
      .builder()
      .optionallyWith(
        subjectAlternativeNames.map(value => value.buildAwsValue())
      )(_.subjectAlternativeNames)
      .trust(trust.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext
      .wrap(buildAwsValue())
}
object VirtualGatewayListenerTlsValidationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext =
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext(
        subjectAlternativeNames.map(value => value.asEditable),
        trust.asEditable
      )
    def subjectAlternativeNames
        : Optional[zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly]
    def trust
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly
    def getSubjectAlternativeNames: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly
    ] = AwsError.unwrapOptionField(
      "subjectAlternativeNames",
      subjectAlternativeNames
    )
    def getTrust: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly
    ] = ZIO.succeed(trust)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContext
  ) extends zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext.ReadOnly {
    override val subjectAlternativeNames
        : Optional[zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subjectAlternativeNames())
        .map(value => zio.aws.appmesh.model.SubjectAlternativeNames.wrap(value))
    override val trust
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
        .wrap(impl.trust())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContext
  ): zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext.ReadOnly =
    new Wrapper(impl)
}
