package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VirtualGatewayListenerTlsValidationContextTrust(
    file: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
    ] = Optional.Absent,
    sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust = {
    import VirtualGatewayListenerTlsValidationContextTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
      .builder()
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
      .wrap(buildAwsValue())
}
object VirtualGatewayListenerTlsValidationContextTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust =
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust(
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def file: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ]
    def sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ]
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
  ) extends zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly {
    override val file: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.file())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
          .wrap(value)
      )
    override val sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sds())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
  ): zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly =
    new Wrapper(impl)
}
