package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.FilePath
import scala.jdk.CollectionConverters._
final case class VirtualGatewayTlsValidationContextFileTrust(
    certificateChain: FilePath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextFileTrust = {
    import VirtualGatewayTlsValidationContextFileTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
      .builder()
      .certificateChain(FilePath.unwrap(certificateChain): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
      .wrap(buildAwsValue())
}
object VirtualGatewayTlsValidationContextFileTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust =
      zio.aws.appmesh.model
        .VirtualGatewayTlsValidationContextFileTrust(certificateChain)
    def certificateChain: FilePath
    def getCertificateChain: ZIO[Any, Nothing, FilePath] =
      ZIO.succeed(certificateChain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
  ) extends zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly {
    override val certificateChain: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.certificateChain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
  ): zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly =
    new Wrapper(impl)
}
