package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class VirtualNodeData(
    meshName: ResourceName,
    metadata: zio.aws.appmesh.model.ResourceMetadata,
    spec: zio.aws.appmesh.model.VirtualNodeSpec,
    status: zio.aws.appmesh.model.VirtualNodeStatus,
    virtualNodeName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeData = {
    import VirtualNodeData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeData
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .metadata(metadata.buildAwsValue())
      .spec(spec.buildAwsValue())
      .status(status.buildAwsValue())
      .virtualNodeName(ResourceName.unwrap(virtualNodeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualNodeData.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeData.wrap(buildAwsValue())
}
object VirtualNodeData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeData =
      zio.aws.appmesh.model.VirtualNodeData(
        meshName,
        metadata.asEditable,
        spec.asEditable,
        status.asEditable,
        virtualNodeName
      )
    def meshName: ResourceName
    def metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly
    def spec: zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly
    def status: zio.aws.appmesh.model.VirtualNodeStatus.ReadOnly
    def virtualNodeName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMetadata
        : ZIO[Any, Nothing, zio.aws.appmesh.model.ResourceMetadata.ReadOnly] =
      ZIO.succeed(metadata)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeStatus.ReadOnly] =
      ZIO.succeed(status)
    def getVirtualNodeName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualNodeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeData
  ) extends zio.aws.appmesh.model.VirtualNodeData.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly =
      zio.aws.appmesh.model.ResourceMetadata.wrap(impl.metadata())
    override val spec: zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly =
      zio.aws.appmesh.model.VirtualNodeSpec.wrap(impl.spec())
    override val status: zio.aws.appmesh.model.VirtualNodeStatus.ReadOnly =
      zio.aws.appmesh.model.VirtualNodeStatus.wrap(impl.status())
    override val virtualNodeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualNodeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeData
  ): zio.aws.appmesh.model.VirtualNodeData.ReadOnly = new Wrapper(impl)
}
