package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.MaxRequests
import scala.jdk.CollectionConverters._
final case class VirtualNodeGrpcConnectionPool(maxRequests: MaxRequests) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeGrpcConnectionPool = {
    import VirtualNodeGrpcConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeGrpcConnectionPool
      .builder()
      .maxRequests(MaxRequests.unwrap(maxRequests): Integer)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool.wrap(buildAwsValue())
}
object VirtualNodeGrpcConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeGrpcConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool =
      zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool(maxRequests)
    def maxRequests: MaxRequests
    def getMaxRequests: ZIO[Any, Nothing, MaxRequests] =
      ZIO.succeed(maxRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeGrpcConnectionPool
  ) extends zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool.ReadOnly {
    override val maxRequests: MaxRequests =
      zio.aws.appmesh.model.primitives.MaxRequests(impl.maxRequests())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeGrpcConnectionPool
  ): zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool.ReadOnly = new Wrapper(
    impl
  )
}
