package zio.aws.appmesh.model
import scala.jdk.CollectionConverters._
sealed trait VirtualNodeStatusCode {
  def unwrap
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode
}
object VirtualNodeStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode
  ): zio.aws.appmesh.model.VirtualNodeStatusCode = value match {
    case software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.VirtualNodeStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.appmesh.model.VirtualNodeStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode.ACTIVE
  }
  case object INACTIVE extends zio.aws.appmesh.model.VirtualNodeStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode.INACTIVE
  }
  case object DELETED extends zio.aws.appmesh.model.VirtualNodeStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualNodeStatusCode.DELETED
  }
}
