package zio.aws.appmesh
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.appmesh.model.primitives.{
  HttpRetryPolicyEvent,
  PortNumber,
  Arn,
  SubjectAlternativeName,
  TagKey
}
import zio.aws.appmesh.model.primitives.FilePath.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.appmesh.model.primitives.AccountId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.appmesh.model.primitives.Arn.Type
    object AwsCloudMapInstanceAttributeKey extends Subtype[String]
    type AwsCloudMapInstanceAttributeKey =
      zio.aws.appmesh.model.primitives.AwsCloudMapInstanceAttributeKey.Type
    object AwsCloudMapInstanceAttributeValue extends Subtype[String]
    type AwsCloudMapInstanceAttributeValue =
      zio.aws.appmesh.model.primitives.AwsCloudMapInstanceAttributeValue.Type
    object AwsCloudMapName extends Subtype[String]
    type AwsCloudMapName = zio.aws.appmesh.model.primitives.AwsCloudMapName.Type
    object DurationValue extends Subtype[Long]
    type DurationValue = zio.aws.appmesh.model.primitives.DurationValue.Type
    object ExactHostName extends Subtype[String]
    type ExactHostName = zio.aws.appmesh.model.primitives.ExactHostName.Type
    object FilePath extends Subtype[String]
    type FilePath = zio.aws.appmesh.model.primitives.FilePath.Type
    object GatewayRoutePriority extends Subtype[Int]
    type GatewayRoutePriority =
      zio.aws.appmesh.model.primitives.GatewayRoutePriority.Type
    object HeaderMatch extends Subtype[String]
    type HeaderMatch = zio.aws.appmesh.model.primitives.HeaderMatch.Type
    object HeaderName extends Subtype[String]
    type HeaderName = zio.aws.appmesh.model.primitives.HeaderName.Type
    object HealthCheckIntervalMillis extends Subtype[Long]
    type HealthCheckIntervalMillis =
      zio.aws.appmesh.model.primitives.HealthCheckIntervalMillis.Type
    object HealthCheckThreshold extends Subtype[Int]
    type HealthCheckThreshold =
      zio.aws.appmesh.model.primitives.HealthCheckThreshold.Type
    object HealthCheckTimeoutMillis extends Subtype[Long]
    type HealthCheckTimeoutMillis =
      zio.aws.appmesh.model.primitives.HealthCheckTimeoutMillis.Type
    object Hostname extends Subtype[String]
    type Hostname = zio.aws.appmesh.model.primitives.Hostname.Type
    object HttpGatewayRoutePrefix extends Subtype[String]
    type HttpGatewayRoutePrefix =
      zio.aws.appmesh.model.primitives.HttpGatewayRoutePrefix.Type
    object HttpPathExact extends Subtype[String]
    type HttpPathExact = zio.aws.appmesh.model.primitives.HttpPathExact.Type
    object HttpPathRegex extends Subtype[String]
    type HttpPathRegex = zio.aws.appmesh.model.primitives.HttpPathRegex.Type
    object HttpRetryPolicyEvent extends Subtype[String]
    type HttpRetryPolicyEvent =
      zio.aws.appmesh.model.primitives.HttpRetryPolicyEvent.Type
    object ListGatewayRoutesLimit extends Subtype[Int]
    type ListGatewayRoutesLimit =
      zio.aws.appmesh.model.primitives.ListGatewayRoutesLimit.Type
    object ListMeshesLimit extends Subtype[Int]
    type ListMeshesLimit = zio.aws.appmesh.model.primitives.ListMeshesLimit.Type
    object ListRoutesLimit extends Subtype[Int]
    type ListRoutesLimit = zio.aws.appmesh.model.primitives.ListRoutesLimit.Type
    object ListVirtualGatewaysLimit extends Subtype[Int]
    type ListVirtualGatewaysLimit =
      zio.aws.appmesh.model.primitives.ListVirtualGatewaysLimit.Type
    object ListVirtualNodesLimit extends Subtype[Int]
    type ListVirtualNodesLimit =
      zio.aws.appmesh.model.primitives.ListVirtualNodesLimit.Type
    object ListVirtualRoutersLimit extends Subtype[Int]
    type ListVirtualRoutersLimit =
      zio.aws.appmesh.model.primitives.ListVirtualRoutersLimit.Type
    object ListVirtualServicesLimit extends Subtype[Int]
    type ListVirtualServicesLimit =
      zio.aws.appmesh.model.primitives.ListVirtualServicesLimit.Type
    object MaxConnections extends Subtype[Int]
    type MaxConnections = zio.aws.appmesh.model.primitives.MaxConnections.Type
    object MaxPendingRequests extends Subtype[Int]
    type MaxPendingRequests =
      zio.aws.appmesh.model.primitives.MaxPendingRequests.Type
    object MaxRequests extends Subtype[Int]
    type MaxRequests = zio.aws.appmesh.model.primitives.MaxRequests.Type
    object MaxRetries extends Subtype[Long]
    type MaxRetries = zio.aws.appmesh.model.primitives.MaxRetries.Type
    object MethodName extends Subtype[String]
    type MethodName = zio.aws.appmesh.model.primitives.MethodName.Type
    object OutlierDetectionMaxEjectionPercent extends Subtype[Int]
    type OutlierDetectionMaxEjectionPercent =
      zio.aws.appmesh.model.primitives.OutlierDetectionMaxEjectionPercent.Type
    object OutlierDetectionMaxServerErrors extends Subtype[Long]
    type OutlierDetectionMaxServerErrors =
      zio.aws.appmesh.model.primitives.OutlierDetectionMaxServerErrors.Type
    object PercentInt extends Subtype[Int]
    type PercentInt = zio.aws.appmesh.model.primitives.PercentInt.Type
    object PortNumber extends Subtype[Int]
    type PortNumber = zio.aws.appmesh.model.primitives.PortNumber.Type
    object QueryParameterName extends Subtype[String]
    type QueryParameterName =
      zio.aws.appmesh.model.primitives.QueryParameterName.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.appmesh.model.primitives.ResourceName.Type
    object RoutePriority extends Subtype[Int]
    type RoutePriority = zio.aws.appmesh.model.primitives.RoutePriority.Type
    object SdsSecretName extends Subtype[String]
    type SdsSecretName = zio.aws.appmesh.model.primitives.SdsSecretName.Type
    object ServiceName extends Subtype[String]
    type ServiceName = zio.aws.appmesh.model.primitives.ServiceName.Type
    object SubjectAlternativeName extends Subtype[String]
    type SubjectAlternativeName =
      zio.aws.appmesh.model.primitives.SubjectAlternativeName.Type
    object SuffixHostname extends Subtype[String]
    type SuffixHostname = zio.aws.appmesh.model.primitives.SuffixHostname.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.appmesh.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.appmesh.model.primitives.TagValue.Type
    object TagsLimit extends Subtype[Int]
    type TagsLimit = zio.aws.appmesh.model.primitives.TagsLimit.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.appmesh.model.primitives.Timestamp.Type
    object VirtualGatewayHealthCheckIntervalMillis extends Subtype[Long]
    type VirtualGatewayHealthCheckIntervalMillis =
      zio.aws.appmesh.model.primitives.VirtualGatewayHealthCheckIntervalMillis.Type
    object VirtualGatewayHealthCheckThreshold extends Subtype[Int]
    type VirtualGatewayHealthCheckThreshold =
      zio.aws.appmesh.model.primitives.VirtualGatewayHealthCheckThreshold.Type
    object VirtualGatewayHealthCheckTimeoutMillis extends Subtype[Long]
    type VirtualGatewayHealthCheckTimeoutMillis =
      zio.aws.appmesh.model.primitives.VirtualGatewayHealthCheckTimeoutMillis.Type
    object VirtualGatewaySdsSecretName extends Subtype[String]
    type VirtualGatewaySdsSecretName =
      zio.aws.appmesh.model.primitives.VirtualGatewaySdsSecretName.Type
  }
  type AwsCloudMapInstanceAttributes =
    List[zio.aws.appmesh.model.AwsCloudMapInstanceAttribute]
  type Backends = List[zio.aws.appmesh.model.Backend]
  type CertificateAuthorityArns = List[Arn]
  type GatewayRouteList = List[zio.aws.appmesh.model.GatewayRouteRef]
  type GrpcGatewayRouteMetadataList =
    List[zio.aws.appmesh.model.GrpcGatewayRouteMetadata]
  type GrpcRetryPolicyEvents = List[zio.aws.appmesh.model.GrpcRetryPolicyEvent]
  type GrpcRouteMetadataList = List[zio.aws.appmesh.model.GrpcRouteMetadata]
  type HttpGatewayRouteHeaders =
    List[zio.aws.appmesh.model.HttpGatewayRouteHeader]
  type HttpQueryParameters = List[zio.aws.appmesh.model.HttpQueryParameter]
  type HttpRetryPolicyEvents = List[HttpRetryPolicyEvent]
  type HttpRouteHeaders = List[zio.aws.appmesh.model.HttpRouteHeader]
  type Listeners = List[zio.aws.appmesh.model.Listener]
  type MeshList = List[zio.aws.appmesh.model.MeshRef]
  type PortSet = List[PortNumber]
  type RouteList = List[zio.aws.appmesh.model.RouteRef]
  type SubjectAlternativeNameList = List[SubjectAlternativeName]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.appmesh.model.TagRef]
  type TcpRetryPolicyEvents = List[zio.aws.appmesh.model.TcpRetryPolicyEvent]
  type VirtualGatewayCertificateAuthorityArns = List[Arn]
  type VirtualGatewayList = List[zio.aws.appmesh.model.VirtualGatewayRef]
  type VirtualGatewayListeners =
    List[zio.aws.appmesh.model.VirtualGatewayListener]
  type VirtualNodeList = List[zio.aws.appmesh.model.VirtualNodeRef]
  type VirtualRouterList = List[zio.aws.appmesh.model.VirtualRouterRef]
  type VirtualRouterListeners =
    List[zio.aws.appmesh.model.VirtualRouterListener]
  type VirtualServiceList = List[zio.aws.appmesh.model.VirtualServiceRef]
  type WeightedTargets = List[zio.aws.appmesh.model.WeightedTarget]
}
