package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientTlsCertificate(
    file: Optional[zio.aws.appmesh.model.ListenerTlsFileCertificate] =
      Optional.Absent,
    sds: Optional[zio.aws.appmesh.model.ListenerTlsSdsCertificate] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate = {
    import ClientTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate
      .builder()
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly =
    zio.aws.appmesh.model.ClientTlsCertificate.wrap(buildAwsValue())
}
object ClientTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ClientTlsCertificate =
      zio.aws.appmesh.model.ClientTlsCertificate(
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def file
        : Optional[zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly]
    def sds: Optional[zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly]
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate
  ) extends zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly {
    override val file
        : Optional[zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.file())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsFileCertificate.wrap(value)
        )
    override val sds
        : Optional[zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sds())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsSdsCertificate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate
  ): zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly = new Wrapper(impl)
}
