package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVirtualServiceResponse(
    virtualService: zio.aws.appmesh.model.VirtualServiceData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceResponse = {
    import DeleteVirtualServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceResponse
      .builder()
      .virtualService(virtualService.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteVirtualServiceResponse.ReadOnly =
    zio.aws.appmesh.model.DeleteVirtualServiceResponse.wrap(buildAwsValue())
}
object DeleteVirtualServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteVirtualServiceResponse =
      zio.aws.appmesh.model
        .DeleteVirtualServiceResponse(virtualService.asEditable)
    def virtualService: zio.aws.appmesh.model.VirtualServiceData.ReadOnly
    def getVirtualService
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualServiceData.ReadOnly] =
      ZIO.succeed(virtualService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceResponse
  ) extends zio.aws.appmesh.model.DeleteVirtualServiceResponse.ReadOnly {
    override val virtualService
        : zio.aws.appmesh.model.VirtualServiceData.ReadOnly =
      zio.aws.appmesh.model.VirtualServiceData.wrap(impl.virtualService())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceResponse
  ): zio.aws.appmesh.model.DeleteVirtualServiceResponse.ReadOnly = new Wrapper(
    impl
  )
}
