package zio.aws.appmesh.model
import scala.jdk.CollectionConverters._
sealed trait DnsResponseType {
  def unwrap: software.amazon.awssdk.services.appmesh.model.DnsResponseType
}
object DnsResponseType {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.DnsResponseType
  ): zio.aws.appmesh.model.DnsResponseType = value match {
    case software.amazon.awssdk.services.appmesh.model.DnsResponseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.DnsResponseType.LOADBALANCER =>
      val r = LOADBALANCER
      r
    case software.amazon.awssdk.services.appmesh.model.DnsResponseType.ENDPOINTS =>
      val r = ENDPOINTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.DnsResponseType {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DnsResponseType =
      software.amazon.awssdk.services.appmesh.model.DnsResponseType.UNKNOWN_TO_SDK_VERSION
  }
  case object LOADBALANCER extends zio.aws.appmesh.model.DnsResponseType {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DnsResponseType =
      software.amazon.awssdk.services.appmesh.model.DnsResponseType.LOADBALANCER
  }
  case object ENDPOINTS extends zio.aws.appmesh.model.DnsResponseType {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DnsResponseType =
      software.amazon.awssdk.services.appmesh.model.DnsResponseType.ENDPOINTS
  }
}
